<?php
include 'config.php';
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نظام متابعة جودة رياض الأطفال</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --accent-color: #f8b400;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
            --success-color: #4caf50;
            --info-color: #00bcd4;
            --warning-color: #ff9800;
            --danger-color: #f44336;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .header h2 {
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 0;
        }
        
        .container {
            max-width: 1200px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #dee2e6;
            margin-bottom: 1.5rem;
        }
        
        .nav-tabs .nav-link {
            border: 1px solid #dee2e6;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-left: 5px;
            background: #f8f9fa;
            color: var(--dark-color);
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .nav-tabs .nav-link.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
        
        .tab-content {
            padding: 25px;
            border: 1px solid #dee2e6;
            border-top: none;
            background: white;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 25px;
            background-color: white;
            border-radius: 8px;
            border-left: 5px solid var(--primary-color);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            color: var(--primary-color);
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            background: white;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        th, td {
            border: 1px solid #e0e0e0;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 500;
        }
        
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tr:hover {
            background-color: #f1f1f1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            font-weight: 500;
            color: var(--dark-color);
            margin-bottom: 8px;
            display: block;
        }
        
        .checkbox-group {
            display: flex;
            gap: 20px;
            margin: 15px 0;
            flex-wrap: wrap;
        }
        
        .checkbox-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-weight: normal;
        }
        
        input[type="text"],
        input[type="number"],
        input[type="email"],
        input[type="password"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-success {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 12px 30px;
            font-size: 18px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-success:hover {
            background-color: #246b66;
            border-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .btn-success:active {
            transform: translateY(0);
        }
        
        .welcome-message {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            border-left: 4px solid var(--accent-color);
        }
        
        .welcome-message h3 {
            color: var(--dark-color);
            margin-bottom: 0;
            font-weight: 600;
        }
        
        .icon {
            margin-left: 8px;
            color: var(--primary-color);
        }
        
        .disabled-row {
            opacity: 0.6;
            pointer-events: none;
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .nav-tabs .nav-link {
                padding: 10px 15px;
                font-size: 14px;
            }
            
            .section {
                padding: 20px;
            }
            
            th, td {
                padding: 10px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 768px) {
            .header {
                padding: 1.5rem 0;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
            
            .header h2 {
                font-size: 1.3rem;
            }
            
            .nav-tabs {
                flex-wrap: nowrap;
                overflow-x: auto;
                white-space: nowrap;
                -webkit-overflow-scrolling: touch;
                padding-bottom: 5px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .tab-content {
                padding: 15px;
            }
            
            .section {
                padding: 15px;
            }
            
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            .checkbox-group {
                gap: 10px;
            }
        }
        
        @media (max-width: 576px) {
            .header h1 {
                font-size: 1.5rem;
            }
            
            .header h2 {
                font-size: 1.1rem;
            }
            
            .btn-success {
                width: 100%;
                padding: 12px;
            }
            
            .checkbox-group {
                flex-direction: column;
                gap: 8px;
            }
        }
    </style>
</head>
<body>

    <div class="header text-center">
        <div class="container">
            <h1><i class="fas fa-child icon"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <h2><i class="fas fa-map-marker-alt icon"></i> في جمهورية مصر العربية</h2>
            <p><i class="fas fa-university icon"></i> المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
    </div>

    <div class="container py-3">
        <div class="welcome-message">
            <h3><i class="fas fa-user-circle"></i> مرحبًا، <?php echo $_SESSION['fullname']; ?></h3>
        </div>
        
        <form action="save_data.php" method="POST" enctype="multipart/form-data">
            
            <!-- Tabs Navigation -->
            <ul class="nav nav-tabs" id="formTabs">
                <li class="nav-item">
                    <a class="nav-link active" data-bs-toggle="tab" href="#general">
                        <i class="fas fa-info-circle"></i> البيانات العامة
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#teachers">
                        <i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#activities">
                        <i class="fas fa-book-open"></i> أنشطة التعليم والتعلم
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#facilities">
                        <i class="fas fa-school"></i> مرافق الروضة
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#evaluation">
                        <i class="fas fa-clipboard-check"></i> تقويم الأطفال من وجهة نظر المعلمات
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" data-bs-toggle="tab" href="#evaluation5">
                        <i class="fas fa-user-tie"></i> تقييم الأطفال من قبل القائم بالتطبيق
                    </a>
                </li>
            </ul>

            <!-- Tabs Content -->
            <div class="tab-content">
                <!-- General Information Tab -->
                <div class="tab-pane fade show active" id="general">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-info-circle"></i> البيانات الأساسية</h2>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="governorate"><i class="fas fa-map-marked-alt"></i> المحافظة:</label>
                                    <select id="governorate" name="governorate" class="form-select" required>
                                        <option value="">اختر المحافظة</option>
                                        <?php
                                        $sql = "SELECT * FROM governorates";
                                        $result = $conn->query($sql);
                                        while ($row = $result->fetch_assoc()) {
                                            echo "<option value='{$row['GovernorateID']}'>{$row['GovernorateName']}</option>";
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="directorate"><i class="fas fa-building"></i> الإدارة التعليمية:</label>
                                    <select id="directorate" name="directorate" class="form-select" required disabled>
                                        <option value="">اختر الإدارة التعليمية</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="school"><i class="fas fa-school"></i> اسم الروضة:</label>
                                    <select name="school" id="school" class="form-select" required disabled>
                                        <option value="">اختر الروضة</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-flag"></i> تبعية الروضة:</label>
                                    <div class="checkbox-group">
                                        <label>
                                            <input type="checkbox" id="official" name="affiliation" value="1" onclick="toggleCheckboxes(this)">
                                            رسمي
                                        </label>
                                        <label>
                                            <input type="checkbox" id="experimental" name="affiliation" value="2" onclick="toggleCheckboxes(this)">
                                            تجريبي
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-tree"></i> البيئة المحيطة بالروضة:</label>
                                    <div class="checkbox-group">
                                        <label>
                                            <input type="radio" id="rural" name="environment" value="2">
                                            ريف
                                        </label>
                                        <label>
                                            <input type="radio" id="urban" name="environment" value="1">
                                            حضر
                                        </label>
                                        <label>
                                            <input type="radio" id="coastal" name="environment" value="3">
                                            ساحلية
                                        </label>
                                        <label>
                                            <input type="radio" id="desert" name="environment" value="4">
                                            صحراوية
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="total-teachers"><i class="fas fa-chalkboard-teacher"></i> العدد الإجمالي للمعلمات بالروضة:</label>
                                    <input type="number" id="total-teachers" name="total-teachers" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="paid-teachers"><i class="fas fa-money-bill-wave"></i> عدد المعلمات التي تتقاضى أجراً:</label>
                                    <input type="number" id="paid-teachers" name="paid-teachers" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="volunteer-teachers"><i class="fas fa-hands-helping"></i> عدد المعلمات التي لا تتقاضى أجراً:</label>
                                    <input type="number" id="volunteer-teachers" name="volunteer-teachers" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
            
                    <!-- Targeted Kindergarten Data -->
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-school"></i> بيانات الروضة المستهدفة</h2>
                        
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label><i class="fas fa-graduation-cap"></i> الصف:</label>
                                    <div class="checkbox-group">
                                        <label>
                                            <input type="radio" id="kg1" name="grade" value="1">
                                            KG1
                                        </label>
                                        <label>
                                            <input type="radio" id="kg2" name="grade" value="2">
                                            KG2
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="room-number"><i class="fas fa-door-open"></i> رقم القاعة:</label>
                                    <input type="number" id="room-number" name="room-number" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="children-count"><i class="fas fa-child"></i> عدد الأطفال في القاعة:</label>
                                    <input type="number" id="children-count" name="children-count" class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="teacher1-code"><i class="fas fa-user-tie"></i> كود المعلمة (1):</label>
                                    <input type="text" id="teacher1-code" name="teacher1-code" class="form-control">
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="teacher2-code"><i class="fas fa-user-tie"></i> كود المعلمة (2):</label>
                                    <input type="text" id="teacher2-code" name="teacher2-code" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                    

                <!-- Teachers Tab -->
                <div class="tab-pane fade" id="teachers">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات</h2>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th colspan="2">معلمة (1)</th>
                                        <th colspan="2">معلمة (2)</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>هل لديك أسئلة أخرى يمكن توضيحها؟</td>
                                        <td><input type="radio" name="t1_Q1" value=2></td>
                                        <td><input type="radio" name="t1_Q1" value=1></td>
                                        <td><input type="radio" name="t2_Q1" value=2></td>
                                        <td><input type="radio" name="t2_Q1" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>هل أنتِ مستعدة للمشاركة؟</td>
                                        <td><input type="radio" name="t1_Q2" value=2></td>
                                        <td><input type="radio" name="t1_Q2" value=1></td>
                                        <td><input type="radio" name="t2_Q2" value=2></td>
                                        <td><input type="radio" name="t2_Q2" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
            
                        <h3 class="section-title"><i class="fas fa-info-circle"></i> معلومات أساسية عن المعلمات</h3>
                        
                        <h4><i class="fas fa-graduation-cap"></i> 3- ما أعلى مستوى تعليمي حصلت عليه؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. أقل من الليسانس/ البكالوريوس</td>
                                        <td><input type="radio" name="t1_Q3" value=1></td>
                                        <td><input type="radio" name="t2_Q3" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2. الليسانس/البكالوريوس</td>
                                        <td><input type="radio" name="t1_Q3" value=2></td>
                                        <td><input type="radio" name="t2_Q3" value=2></td>
                                    </tr>
                                    <tr>
                                        <td>3. دبلوم دراسات عليا تربوي</td>
                                        <td><input type="radio" name="t1_Q3" value=3></td>
                                        <td><input type="radio" name="t2_Q3" value=3></td>
                                    </tr>
                                    <tr>
                                        <td>4. ماجستير</td>
                                        <td><input type="radio" name="t1_Q3" value=4></td>
                                        <td><input type="radio" name="t2_Q3" value=4></td>
                                    </tr>
                                    <tr>
                                        <td>5. دكتوراه</td>
                                        <td><input type="radio" name="t1_Q3" value=5></td>
                                        <td><input type="radio" name="t2_Q3" value=5></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-book"></i> 4- إذا كنت حاصلة على درجة علمية فما تخصصك؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1.لا ينطبق (غير حاصل على درجة علمية)</td>
                                        <td><input type="radio" name="t1_Q4" value=1></td>
                                        <td><input type="radio" name="t2_Q4" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2. الطفولة المبكرة</td>
                                        <td><input type="radio" name="t1_Q4" value=2></td>
                                        <td><input type="radio" name="t2_Q4" value=2></td>
                                    </tr>
                                    <tr>
                                        <td>3.التعليم الأساسي</td>
                                        <td><input type="radio" name="t1_Q4" value=3></td>
                                        <td><input type="radio" name="t2_Q4" value=3></td>
                                    </tr>
                                    <tr>
                                        <td>4. آخر</td>
                                        <td><input type="radio" name="t1_Q4" value=4></td>
                                        <td><input type="radio" name="t2_Q4" value=4></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
            
                        <h4><i class="fas fa-calendar-alt"></i> 5- متى بدأت التدريس لأول مرة؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. قبل عام 2000</td>
                                        <td><input type="radio" name="t1_Q5" value=1></td>
                                        <td><input type="radio" name="t2_Q5" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2. بعد عام 2000</td>
                                        <td><input type="radio" name="t1_Q5" value=2></td>
                                        <td><input type="radio" name="t2_Q5" value=2></td>
                                    </tr>
                                    <tr>
                                        <td>3. لا أتذكر </td>
                                        <td><input type="radio" name="t1_Q5" value=3></td>
                                        <td><input type="radio" name="t2_Q5" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-chalkboard"></i> 6- هل حضرت أي تدريب أثناء الخدمة خلال السنة الماضية؟</h4>
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. لا </td>
                                        <td><input type="radio" name="t1_Q6" value=1></td>
                                        <td><input type="radio" name="t2_Q6" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2. (4 أيام) أو أقل من التدريب/ ورش العمل </td>
                                        <td><input type="radio" name="t1_Q6" value=2></td>
                                        <td><input type="radio" name="t2_Q6" value=2></td>
                                    </tr>
                                    <tr>
                                        <td>3. (5 أيام) أو أكثر من التدريب/ ورش العمل</td>
                                        <td><input type="radio" name="t1_Q6" value=3></td>
                                        <td><input type="radio" name="t2_Q6" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-book-reader"></i> 7- إذا كانت إجابتك رقم 2 أو رقم 3 في السؤال السابق، فما الموضوعات الرئيسة لجلسة (جلسات) التدريب أثناء الخدمة؟</h4>
                        <div class="table-responsive" id="q7-section">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>الخيار</th>
                                        <th>معلمة (1)</th>
                                        <th>معلمة (2)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. منهج جديد لنظام التعليم الجديد الذي بدأ في 2018 في مرحلة الروضة </td>
                                        <td><input type="radio" name="t1_Q7" value=1></td>
                                        <td><input type="radio" name="t2_Q7" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2. برنامج المعلمون أولاً </td>
                                        <td><input type="radio" name="t1_Q7" value=2></td>
                                        <td><input type="radio" name="t2_Q7" value=2></td>
                                    </tr>
                                    <tr>
                                        <td>3.غيرها</td>
                                        <td><input type="radio" name="t1_Q7" value=3></td>
                                        <td><input type="radio" name="t2_Q7" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Activities Tab -->
                <div class="tab-pane fade" id="activities">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-book-open"></i> أولا: توافر أدوات أنشطة التعليم والتعلم واستخدام الأطفال لها</h2>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الأداة</th>
                                        <th>لا توجد</th>
                                        <th>موجودة، لا يستخدمها الأطفال</th>
                                        <th>يستخدمها بعض الأطفال</th>
                                        <th>يستخدمها جميع الأطفال</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>8</td>
                                        <td>أدوات الكتابة</td>
                                        <td><input type="radio" name="AQ8" value=1></td>
                                        <td><input type="radio" name="AQ8" value=2></td>
                                        <td><input type="radio" name="AQ8" value=3></td>
                                        <td><input type="radio" name="AQ8" value=4></td>
                                    </tr>
                                    <tr>
                                        <td>9</td>
                                        <td>أشياء يمكن تطويعها وتشكيلها (أغطية الزجاجات، النرد، قطع، خرز، صخور، عصى، مواد تستخدم في العد، أو الفرز)</td>
                                        <td><input type="radio" name="AQ9" value=1></td>
                                        <td><input type="radio" name="AQ9" value=2></td>
                                        <td><input type="radio" name="AQ9" value=3></td>
                                        <td><input type="radio" name="AQ9" value=4></td>
                                    </tr>
                                    <tr>
                                        <td>10</td>
                                        <td>أدوات إدارة القاعة (مثل الساعة، نتيجة التقويم السنوية، والجدول الزمني، وخرائط الحائط)</td>
                                        <td><input type="radio" name="AQ10" value=1></td>
                                        <td><input type="radio" name="AQ10" value=2></td>
                                        <td><input type="radio" name="AQ10" value=3></td>
                                        <td><input type="radio" name="AQ10" value=4></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
            
                        <h3 class="section-title"><i class="fas fa-chalkboard-teacher"></i> ثانياً: دور المعلمة مع الطفل أثناء أنشطة التعليم والتعلم</h3>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th colspan="2">معلمة (1)</th>
                                        <th colspan="2">معلمة (2)</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>11</td>
                                        <td>تعطي المعلمة تغذية راجعة لكل طفل بمفرده بشأن إجابة الطفل أو العمل الذي قام به</td>
                                        <td><input type="radio" name="t1r11" value=2></td>
                                        <td><input type="radio" name="t1r11" value=1></td>
                                        <td><input type="radio" name="t2r11" value=2></td>
                                        <td><input type="radio" name="t2r11" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>12</td>
                                        <td>تقوم المعلمة بمشاركة الأطفال في المناقشة.</td>
                                        <td><input type="radio" name="t1d12" value=2></td>
                                        <td><input type="radio" name="t1d12" value=1></td>
                                        <td><input type="radio" name="t2d12" value=2></td>
                                        <td><input type="radio" name="t2d12" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>13</td>
                                        <td>تطرح المعلمة أسئلة مفتوحة النهاية على الأطفال؟ مثل سؤال الطفل ما الذي ترسمه؟ وما رأيك في حالة حدوث...؟ أو أخبرني ماذا فعلت بالأمس؟</td>
                                        <td><input type="radio" name="t1o13" value=2></td>
                                        <td><input type="radio" name="t1o13" value=1></td>
                                        <td><input type="radio" name="t2o13" value=2></td>
                                        <td><input type="radio" name="t2o13" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>14</td>
                                        <td>تستخدم المعلمة الاستراتيجيات الخاصة بمنهج نظام التعليم الجديد الذي بدأ في 2018.</td>
                                        <td><input type="radio" name="t1o14" value=2></td>
                                        <td><input type="radio" name="t1o14" value=1></td>
                                        <td><input type="radio" name="t2o14" value=2></td>
                                        <td><input type="radio" name="t2o14" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>15</td>
                                        <td>تقوم المعلمة بربط الأنشطة بالمهارات الحياتية أو بالخبرات اليومية.</td>
                                        <td><input type="radio" name="t1o15" value=2></td>
                                        <td><input type="radio" name="t1o15" value=1></td>
                                        <td><input type="radio" name="t2o15" value=2></td>
                                        <td><input type="radio" name="t2o15" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>16</td>
                                        <td>تبدو المعلمة إيجابية في أغلب الأحيان (ودودة وتتفاعل بشكل إيجابي) مع الأطفال.</td>
                                        <td><input type="radio" name="t1o16" value=2></td>
                                        <td><input type="radio" name="t1o16" value=1></td>
                                        <td><input type="radio" name="t2o16" value=2></td>
                                        <td><input type="radio" name="t2o16" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>17</td>
                                        <td>تقوم المعلمة بتوجيه الطفل أو معالجة سلوكه السيء(مثل: يركل الأطفال الآخرين أو البالغين أو يدفعهم أو يضربهم، وتعالج ذلك بإخراج الطفل من الفصل/ إعطائه مهلة خارج الفصل/إعادة التوجيه إلى نشاط مناسب)</td>
                                        <td><input type="radio" name="t1o17" value=2></td>
                                        <td><input type="radio" name="t1o17" value=1></td>
                                        <td><input type="radio" name="t2o17" value=2></td>
                                        <td><input type="radio" name="t2o17" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Facilities Tab -->
                <div class="tab-pane fade" id="facilities">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-school"></i> مرافق الروضة</h2>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th>نعم</th>
                                        <th>لا</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>18</td>
                                        <td> هل جميع الأطفال لديهم مقاعد آمنة مناسبة لأحجامهم؟</td>
                                        <td><input type="checkbox" name="Q18" value=2></td>
                                        <td><input type="checkbox" name="Q18" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>19</td>
                                        <td>هل جميع الأطفال لديهم مكاتب أو مناضد مناسبة لأحجامهم وبها مساحة كافية لتأدية عملهم؟</td>
                                        <td><input type="checkbox" name="Q19" value=2></td>
                                        <td><input type="checkbox" name="Q19" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>20</td>
                                        <td>هل توجد مساحة للأنشطة لجميع الأطفال تكفي لقيامهم من مكاتبهم والاشتراك في الأنشطة التي تتم في قاعة النشاط؟</td>
                                        <td><input type="checkbox" name="Q20" value=2></td>
                                        <td><input type="checkbox" name="Q20" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>21</td>
                                        <td>هل يوجد أماكن آمنة للأطفال لقيامهم بأنشطة خارج القاعة، ولكن داخل الروضة (مثل حجرات الأنشطة "المخصصة مثلاً للموسيقى والتمثيل"، وصالة الألعاب الرياضية، والحديقة، وملعب الروضة..... إلخ)</td>
                                        <td><input type="checkbox" name="Q21" value=2></td>
                                        <td><input type="checkbox" name="Q21" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>22</td>
                                        <td>المرافق الصحية:</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>22-1- هل توجد مرافق لدورات مياه صحية للأطفال من الجنسين لكلا من الذكور والإناث؟</td>
                                        <td><input type="checkbox" name="Q22_1" value=2></td>
                                        <td><input type="checkbox" name="Q22_1" value=1></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>22-2- هل توجد مياه جارية ونظيفة؟</td>
                                        <td><input type="checkbox" name="Q22_2" value=2></td>
                                        <td><input type="checkbox" name="Q22_2" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>23</td>
                                        <td>هل هناك صابون ومناديل ومواد مطهرة؟</td>
                                        <td><input type="checkbox" name="Q23" value=2></td>
                                        <td><input type="checkbox" name="Q23" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>24</td>
                                        <td>إذا كانت الإجابة بنعم، هل يغسل جميع الأطفال أيديهم بالماء والصابون بعد استخدام المرحاض؟</td>
                                        <td><input type="checkbox" name="Q24" value=2></td>
                                        <td><input type="checkbox" name="Q24" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>25</td>
                                        <td>هل يتوافر للأطفال مصدر صحي لمياه الشرب النظيفة؟</td>
                                        <td><input type="checkbox" name="Q25" value=2></td>
                                        <td><input type="checkbox" name="Q25" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>26</td>
                                        <td>هل تتوافر عوامل الأمن والسلامة بمبنى الروضة ومرافقها</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>1. أرضيات مكسورة أو غير مستوية.</td>
                                        <td><input type="checkbox" name="Q26_1[]" value=1></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>2. الكراسي أو المناضد مكسورة.</td>
                                        <td><input type="checkbox" name="Q26_2[]" value=2></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>3. يوجد تسرب بالسقف أو ثقوب في السقف.</td>
                                        <td><input type="checkbox" name="Q26_3[]" value=3></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>4. نوافذ أو أبواب مكسورة.</td>
                                        <td><input type="checkbox" name="Q26_4[]" value=4></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>5. الإضاءة الطبيعية غير كافية.</td>
                                        <td><input type="checkbox" name="Q26_5[]" value=5></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>6. التهوية غير كافية.</td>
                                        <td><input type="checkbox" name="Q26_6[]" value=6></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>7. ملاعب صخرية بها مهملات أو حفر مفتوحة.</td>
                                        <td><input type="checkbox" name="Q26_7[]" value=7></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>8. عدم وجود سور حول مبنى المدرسة.</td>
                                        <td><input type="checkbox" name="Q26_8[]" value=8></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>9. المدرسة بالقرب من الطرق الرئيسية.</td>
                                        <td><input type="checkbox" name="Q26_9[]" value=9></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>10. حالات أخرى من المحتمل أن تسبب إصابة للأطفال.</td>
                                        <td><input type="checkbox" name="Q26_10[]" value=10></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td>11. لا شيء.</td>
                                        <td><input type="checkbox" name="Q26_11[]" value=11></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Evaluation Tab -->
                <div class="tab-pane fade" id="evaluation">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-clipboard-check"></i> المحور الرابع: تقويم الأطفال من وجهة نظر المعلمات</h2>
                        
                        <h3 class="section-title"><i class="fas fa-check-circle"></i> أولاً: نموذج موافقة المعلمة</h3>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th>نعم</th>
                                        <th>لا</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>هل لديك أسئلة أخرى يمكن توضيحها؟</td>
                                        <td><input type="checkbox" name="Q4_1" value=2></td>
                                        <td><input type="checkbox" name="Q4_1" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>2</td>
                                        <td>هل أنتِ مستعدة للمشاركة؟</td>
                                        <td><input type="checkbox" name="Q4_2" value=2></td>
                                        <td><input type="checkbox" name="Q4_2" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
            
                        <h3 class="section-title"><i class="fas fa-clipboard-list"></i> ثانياً: تقرير المعلمة</h3>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>السؤال</th>
                                        <th colspan="2">الطفل الأول</th>
                                        <th colspan="2">الطفل الثاني</th>
                                        <th colspan="2">الطفل الثالث</th>
                                        <th colspan="2">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>27</td>
                                        <td>هل يواصل الطفل العمل في شيء ما حتى ينتهي منه؟</td>
                                        <td><input type="checkbox" name="Q27_ch1" value=2></td>
                                        <td><input type="checkbox" name="Q27_ch1" value=1></td>
                                        <td><input type="checkbox" name="Q27_ch2" value=2></td>
                                        <td><input type="checkbox" name="Q27_ch2" value=1></td>
                                        <td><input type="checkbox" name="Q27_ch3" value=2></td>
                                        <td><input type="checkbox" name="Q27_ch3" value=1></td>
                                        <td><input type="checkbox" name="Q27_ch4" value=2></td>
                                        <td><input type="checkbox" name="Q27_ch4" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>28</td>
                                        <td>هل يتبع الطفل جميع التعليمات التي قمت بإعطائها له؟.</td>
                                        <td><input type="checkbox" name="Q28_ch1" value=2></td>
                                        <td><input type="checkbox" name="Q28_ch1" value=1></td>
                                        <td><input type="checkbox" name="Q28_ch2" value=2></td>
                                        <td><input type="checkbox" name="Q28_ch2" value=1></td>
                                        <td><input type="checkbox" name="Q28_ch3" value=2></td>
                                        <td><input type="checkbox" name="Q28_ch3" value=1></td>
                                        <td><input type="checkbox" name="Q28_ch4" value=2></td>
                                        <td><input type="checkbox" name="Q28_ch4" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>29</td>
                                        <td>هل يظهر الطفل من خلال أفعاله مراعاته لشعور الآخرين؟.</td>
                                        <td><input type="checkbox" name="Q29_ch1" value=2></td>
                                        <td><input type="checkbox" name="Q29_ch1" value=1></td>
                                        <td><input type="checkbox" name="Q29_ch2" value=2></td>
                                        <td><input type="checkbox" name="Q29_ch2" value=1></td>
                                        <td><input type="checkbox" name="Q29_ch3" value=2></td>
                                        <td><input type="checkbox" name="Q29_ch3" value=1></td>
                                        <td><input type="checkbox" name="Q29_ch4" value=2></td>
                                        <td><input type="checkbox" name="Q29_ch4" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
           
                <!-- Evaluation Tab -->
                <div class="tab-pane fade" id="evaluation5">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-user-tie"></i> المحور الخامس : تقويم الأطفال من قبل القائم بالتطبيق</h2>
                        
                        <h3 class="section-title"><i class="fas fa-handshake"></i> أولاً: تحية وموافقة شفهية</h3>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>السؤال</th>
                                        <th colspan="2">الطفل الأول</th>
                                        <th colspan="2">الطفل الثاني</th>
                                        <th colspan="2">الطفل الثالث</th>
                                        <th colspan="2">الطفل الرابع</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>هل كل شيء واضح؟</td>
                                        <td><input type="checkbox" name="S5_1_ch1" value=2></td>
                                        <td><input type="checkbox" name="S5_1_ch1" value=1></td>
                                        <td><input type="checkbox" name="S5_1_ch2" value=2></td>
                                        <td><input type="checkbox" name="S5_1_ch2" value=1></td>
                                        <td><input type="checkbox" name="S5_1_ch3" value=2></td>
                                        <td><input type="checkbox" name="S5_1_ch3" value=1></td>
                                        <td><input type="checkbox" name="S5_1_ch4" value=2></td>
                                        <td><input type="checkbox" name="S5_1_ch4" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>هل عندك أي أسئلة؟</td>
                                        <td><input type="checkbox" name="S5_2_ch1" value=2></td>
                                        <td><input type="checkbox" name="S5_2_ch1" value=1></td>
                                        <td><input type="checkbox" name="S5_2_ch2" value=2></td>
                                        <td><input type="checkbox" name="S5_2_ch2" value=1></td>
                                        <td><input type="checkbox" name="S5_2_ch3" value=2></td>
                                        <td><input type="checkbox" name="S5_2_ch3" value=1></td>
                                        <td><input type="checkbox" name="S5_2_ch4" value=2></td>
                                        <td><input type="checkbox" name="S5_2_ch4" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>هل أنتِ مستعد لتبدأ؟</td>
                                        <td><input type="checkbox" name="S5_3_ch1" value=2></td>
                                        <td><input type="checkbox" name="S5_3_ch1" value=1></td>
                                        <td><input type="checkbox" name="S5_3_ch2" value=2></td>
                                        <td><input type="checkbox" name="S5_3_ch2" value=1></td>
                                        <td><input type="checkbox" name="S5_3_ch3" value=2></td>
                                        <td><input type="checkbox" name="S5_3_ch3" value=1></td>
                                        <td><input type="checkbox" name="S5_3_ch4" value=2></td>
                                        <td><input type="checkbox" name="S5_3_ch4" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
           
                        <h3 class="section-title"><i class="fas fa-clipboard-check"></i> ثانياً: التقييم الأساسي المباشر</h3>
                        
                        <h4><i class="fas fa-language"></i> 30- التعرف على صوت حروف (اللغة العربية)</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الحرف</th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>30-1</td>
                                        <td>حرف (م)</td>
                                        <td><input type="checkbox" name="Q30_1ch1" value=1></td>
                                        <td><input type="checkbox" name="Q30_1ch1" value=2></td>
                                        <td><input type="checkbox" name="Q30_1ch1" value=3></td>
                                        <td><input type="checkbox" name="Q30_1ch2" value=1></td>
                                        <td><input type="checkbox" name="Q30_1ch2" value=2></td>
                                        <td><input type="checkbox" name="Q30_1ch2" value=3></td>
                                        <td><input type="checkbox" name="Q30_1ch3" value=1></td>
                                        <td><input type="checkbox" name="Q30_1ch3" value=2></td>
                                        <td><input type="checkbox" name="Q30_1ch3" value=3></td>
                                        <td><input type="checkbox" name="Q30_1ch4" value=1></td>
                                        <td><input type="checkbox" name="Q30_1ch4" value=2></td>
                                        <td><input type="checkbox" name="Q30_1ch4" value=3></td>
                                    </tr>
                                    <!-- More rows would go here -->
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- More evaluation tables would go here -->
                        <h4><i class="fas fa-language"></i> 31-التعرف على صوت حروف (اللغة الإنجليزية)</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الحرف</th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>31-1</td>
                                        <td>(m) حرف</td>
                                        <td><input type="checkbox" name="Q31_1ch1" value=1></td>
                                        <td><input type="checkbox" name="Q31_1ch1" value=2></td>
                                        <td><input type="checkbox" name="Q31_1ch1" value=3></td>
                                        <td><input type="checkbox" name="Q31_1ch2" value=1></td>
                                        <td><input type="checkbox" name="Q31_1ch2" value=2></td>
                                        <td><input type="checkbox" name="Q31_1ch2" value=3></td>
                                        <td><input type="checkbox" name="Q31_1ch3" value=1></td>
                                        <td><input type="checkbox" name="Q31_1ch3" value=2></td>
                                        <td><input type="checkbox" name="Q31_1ch3" value=3></td>
                                        <td><input type="checkbox" name="Q31_1ch4" value=1></td>
                                        <td><input type="checkbox" name="Q31_1ch4" value=2></td>
                                        <td><input type="checkbox" name="Q31_1ch4" value=3></td>
                                    </tr>
                                    <!-- More rows would go here -->
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-pen"></i> 32- كتابة الأسماء</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>يطلب من الطفل كتابة اسمه</td>
                                        <td><input type="checkbox" name="Q32ch1" value=1></td>
                                        <td><input type="checkbox" name="Q32ch1" value=2></td>
                                        <td><input type="checkbox" name="Q32ch1" value=3></td>
                                        <td><input type="checkbox" name="Q32ch2" value=1></td>
                                        <td><input type="checkbox" name="Q32ch2" value=2></td>
                                        <td><input type="checkbox" name="Q32ch2" value=3></td>
                                        <td><input type="checkbox" name="Q32ch3" value=1></td>
                                        <td><input type="checkbox" name="Q32ch3" value=2></td>
                                        <td><input type="checkbox" name="Q32ch3" value=3></td>
                                        <td><input type="checkbox" name="Q32ch4" value=1></td>
                                        <td><input type="checkbox" name="Q32ch4" value=2></td>
                                        <td><input type="checkbox" name="Q32ch4" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-sort-numeric-up"></i> 33- العد اللفظي</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>يطلب من الطفل العد اللفظي للأرقام</td>
                                        <td><input type="checkbox" name="Q33ch1" value=1></td>
                                        <td><input type="checkbox" name="Q33ch1" value=2></td>
                                        <td><input type="checkbox" name="Q33ch1" value=3></td>
                                        <td><input type="checkbox" name="Q33ch2" value=1></td>
                                        <td><input type="checkbox" name="Q33ch2" value=2></td>
                                        <td><input type="checkbox" name="Q33ch2" value=3></td>
                                        <td><input type="checkbox" name="Q33ch3" value=1></td>
                                        <td><input type="checkbox" name="Q33ch3" value=2></td>
                                        <td><input type="checkbox" name="Q33ch3" value=3></td>
                                        <td><input type="checkbox" name="Q33ch4" value=1></td>
                                        <td><input type="checkbox" name="Q33ch4" value=2></td>
                                        <td><input type="checkbox" name="Q33ch4" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-shapes"></i> 34- الأشكال الهندسية: تستخدم ورقة عمل (3) الأشكال الهندسية</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1-34</td>
                                        <td>التعرف على الدائرة</td>
                                        <td><input type="checkbox" name="Q34_1ch1" value=1></td>
                                        <td><input type="checkbox" name="Q34_1ch1" value=2></td>
                                        <td><input type="checkbox" name="Q34_1ch1" value=3></td>
                                        <td><input type="checkbox" name="Q34_1ch2" value=1></td>
                                        <td><input type="checkbox" name="Q34_1ch2" value=2></td>
                                        <td><input type="checkbox" name="Q34_1ch2" value=3></td>
                                        <td><input type="checkbox" name="Q34_1ch3" value=1></td>
                                        <td><input type="checkbox" name="Q34_1ch3" value=2></td>
                                        <td><input type="checkbox" name="Q34_1ch3" value=3></td>
                                        <td><input type="checkbox" name="Q34_1ch4" value=1></td>
                                        <td><input type="checkbox" name="Q34_1ch4" value=2></td>
                                        <td><input type="checkbox" name="Q34_1ch4" value=3></td>
                                    </tr>
                                    <!-- More rows would go here -->
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-book"></i> 35- المنهج متعدد التخصصات: تستخدم ورقة عمل (4) الأعلام، وتستخدم ورقة عمل (5) الطقس.</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1-35</td>
                                        <td>ما اسم روضتك؟</td>
                                        <td><input type="checkbox" name="Q35_1ch1" value=1></td>
                                        <td><input type="checkbox" name="Q35_1ch1" value=2></td>
                                        <td><input type="checkbox" name="Q35_1ch1" value=3></td>
                                        <td><input type="checkbox" name="Q35_1ch2" value=1></td>
                                        <td><input type="checkbox" name="Q35_1ch2" value=2></td>
                                        <td><input type="checkbox" name="Q35_1ch2" value=3></td>
                                        <td><input type="checkbox" name="Q35_1ch3" value=1></td>
                                        <td><input type="checkbox" name="Q35_1ch3" value=2></td>
                                        <td><input type="checkbox" name="Q35_1ch3" value=3></td>
                                        <td><input type="checkbox" name="Q35_1ch4" value=1></td>
                                        <td><input type="checkbox" name="Q35_1ch4" value=2></td>
                                        <td><input type="checkbox" name="Q35_1ch4" value=3></td>
                                    </tr>
                                    <!-- More rows would go here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Submit Button -->
            <div class="text-center mt-4 mb-5">
                <button type="submit" class="btn btn-success btn-lg">
                    <i class="fas fa-save"></i> حفظ البيانات
                </button>
            </div>
        </form>
    </div>
      
    <!-- JavaScript Libraries -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/js/all.min.js"></script>
    
    <script>
        // Initialize Bootstrap components
        var formTabs = new bootstrap.Tab(document.getElementById('formTabs'));
        
        // Governorate-Directorate-School cascade dropdown
        document.getElementById('governorate').addEventListener('change', function() {
            var governorateId = this.value;
            var directorateDropdown = document.getElementById('directorate');
            
            if (governorateId) {
                // Enable directorate dropdown
                directorateDropdown.disabled = false;
                
                // Clear existing options
                directorateDropdown.innerHTML = '<option value="">اختر الإدارة التعليمية</option>';
                
                // Fetch directorates based on governorate (AJAX call would go here)
                // This is a simplified example - you would need to implement the actual AJAX call
                // For demonstration, we'll simulate with setTimeout
                setTimeout(function() {
                    // Simulated response - replace with actual AJAX call
                    var simulatedDirectorates = [
                        {id: 1, name: 'الإدارة التعليمية الأولى'},
                        {id: 2, name: 'الإدارة التعليمية الثانية'},
                        {id: 3, name: 'الإدارة التعليمية الثالثة'}
                    ];
                    
                    // Populate directorate dropdown
                    simulatedDirectorates.forEach(function(directorate) {
                        var option = document.createElement('option');
                        option.value = directorate.id;
                        option.textContent = directorate.name;
                        directorateDropdown.appendChild(option);
                    });
                }, 500);
            } else {
                // Disable and reset directorate and school dropdowns
                directorateDropdown.disabled = true;
                document.getElementById('school').disabled = true;
                directorateDropdown.innerHTML = '<option value="">اختر الإدارة التعليمية</option>';
                document.getElementById('school').innerHTML = '<option value="">اختر الروضة</option>';
            }
        });
        
        // Directorate-School cascade dropdown
        document.getElementById('directorate').addEventListener('change', function() {
            var directorateId = this.value;
            var schoolDropdown = document.getElementById('school');
            
            if (directorateId) {
                // Enable school dropdown
                schoolDropdown.disabled = false;
                
                // Clear existing options
                schoolDropdown.innerHTML = '<option value="">اختر الروضة</option>';
                
                // Fetch schools based on directorate (AJAX call would go here)
                // This is a simplified example - you would need to implement the actual AJAX call
                // For demonstration, we'll simulate with setTimeout
                setTimeout(function() {
                    // Simulated response - replace with actual AJAX call
                    var simulatedSchools = [
                        {id: 1, name: 'روضة النور'},
                        {id: 2, name: 'روضة الأمل'},
                        {id: 3, name: 'روضة المستقبل'}
                    ];
                    
                    // Populate school dropdown
                    simulatedSchools.forEach(function(school) {
                        var option = document.createElement('option');
                        option.value = school.id;
                        option.textContent = school.name;
                        schoolDropdown.appendChild(option);
                    });
                }, 500);
            } else {
                // Disable and reset school dropdown
                schoolDropdown.disabled = true;
                schoolDropdown.innerHTML = '<option value="">اختر الروضة</option>';
            }
        });
        
        // Function to toggle checkboxes (only one can be selected)
        function toggleCheckboxes(clickedCheckbox) {
            var checkboxes = document.querySelectorAll('input[name="affiliation"]');
            checkboxes.forEach(function(checkbox) {
                if (checkbox !== clickedCheckbox) {
                    checkbox.checked = false;
                }
            });
        }
    </script>
</body>
</html>