<?php
// Connect to DB
include 'config.php';

// Ensure the connection is established
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$query = "SELECT 
    g.GovernorateName,
    d.DirectorateName,
    s.SchoolID,
    s.SchoolName,
    u.UserID,
    u.FullName,
    MAX(CASE WHEN bq.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_اول,
    MAX(CASE WHEN t.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_ثاني,
    MAX(CASE WHEN a.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_ثالث,
    MAX(CASE WHEN f.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_رابع,
    MAX(CASE WHEN c.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_خامس,
    MAX(CASE WHEN da.SchoolID IS NOT NULL THEN 1 ELSE 0 END) AS محور_سادس
FROM 
    schools s
JOIN 
    directorates d ON s.DirectorateID = d.DirectorateID
JOIN 
    governorates g ON d.GovernorateID = g.GovernorateID
LEFT JOIN 
    basicqualityforms bq ON bq.SchoolID = s.SchoolID
LEFT JOIN 
    users u ON u.UserID = bq.UserID
LEFT JOIN 
    teacherssection_1 t ON s.SchoolID = t.SchoolID
LEFT JOIN 
    activitiessection_2 a ON s.SchoolID = a.SchoolID
LEFT JOIN 
    facilitiessection_3 f ON s.SchoolID = f.SchoolID
LEFT JOIN 
    childrenevaluation_4 c ON s.SchoolID = c.SchoolID
LEFT JOIN 
    directassessment_5 da ON s.SchoolID = da.SchoolID
GROUP BY 
    s.SchoolID, s.SchoolName, d.DirectorateName, g.GovernorateName, u.UserID, u.FullName";

$result = $conn->query($query);

if (!$result) {
    die("Query failed: " . $conn->error);
}

// Start HTML output
echo "<!DOCTYPE html>
<html>
<head>
    <title>School Completion Report</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
            position: sticky;
            top: 0;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .completed {
            color: green;
        }
        .not-completed {
            color: red;
        }
    </style>
</head>
<body>
    <h2>School Completion Report</h2>
    <div style='overflow-x:auto;'>
    <table>
        <tr>
            <th>اسم المحافظة</th>
            <th>الادارة</th>
            <th>اسم المدرسة</th>
            <th>المستخدم</th>
            <th>المحور الاول</th>
            <th>المحور الثاني</th>
            <th>المحور الثالث</th>
            <th>المحور الرابع</th>
            <th>المحور الخامس</th>
            <th>المحور السادس</th>
        </tr>";

while ($row = $result->fetch_assoc()) {
    echo "<tr>
            <td>{$row['GovernorateName']}</td>
            <td>{$row['DirectorateName']}</td>
            <td>{$row['SchoolName']}</td>
            <td>{$row['FullName']}</td>
            <td class='".($row['محور_اول'] ? 'completed' : 'not-completed')."'>".($row['محور_اول'] ? '✅' : '❌')."</td>
            <td class='".($row['محور_ثاني'] ? 'completed' : 'not-completed')."'>".($row['محور_ثاني'] ? '✅' : '❌')."</td>
            <td class='".($row['محور_ثالث'] ? 'completed' : 'not-completed')."'>".($row['محور_ثالث'] ? '✅' : '❌')."</td>
            <td class='".($row['محور_رابع'] ? 'completed' : 'not-completed')."'>".($row['محور_رابع'] ? '✅' : '❌')."</td>
            <td class='".($row['محور_خامس'] ? 'completed' : 'not-completed')."'>".($row['محور_خامس'] ? '✅' : '❌')."</td>
            <td class='".($row['محور_سادس'] ? 'completed' : 'not-completed')."'>".($row['محور_سادس'] ? '✅' : '❌')."</td>
          </tr>";
}

echo "</table>
    </div>
</body>
</html>";
?>