<?php
include 'config.php';

// جلب الإدارات بناءً على المحافظة المختارة عبر AJAX
if (isset($_GET['get_directorates']) && isset($_GET['gov_id'])) {
    $gov_id = intval($_GET['gov_id']);
    $stmt = $conn->prepare("SELECT DirectorateID, DirectorateName FROM directorates WHERE GovernorateID = ?");
    $stmt->bind_param("i", $gov_id);
    $stmt->execute();
    $result = $stmt->get_result();

    $directorates = array();
    while ($row = $result->fetch_assoc()) {
        $directorates[] = $row;
    }
    echo json_encode($directorates);
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8" />
    <title>المدارس المكتملة</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body {
            font-family: 'Cairo', sans-serif;
            background-color: #f4f6f9;
            padding: 40px;
            direction: rtl;
        }

        .container {
            background: white;
            padding: 30px;
            margin: auto;
            width: 90%;
            max-width: 900px;
            border-radius: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }

        h1, h2, h3 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
        }

        select {
            padding: 12px;
            font-size: 16px;
            margin: 10px 0;
            width: 100%;
            border-radius: 8px;
            border: 1px solid #ccc;
        }

        .btn {
            background-color: #28a745;
            color: white;
            padding: 14px 25px;
            border: none;
            font-size: 18px;
            border-radius: 8px;
            cursor: pointer;
            margin-top: 15px;
            width: 100%;
        }

        .btn:hover {
            background-color: #218838;
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #ccc;
            padding: 12px;
            text-align: center;
        }

        th {
            background-color: #007bff;
            color: white;
        }

        .message {
            margin-top: 20px;
            text-align: center;
            color: #555;
            font-size: 18px;
        }
    </style>
</head>
<body>
<div class="container">
    <h2>عرض المدارس المكتملة حسب المحافظة والإدارة</h2>

    <form method="post" id="formFilter">
        <label for="governorate_id">اختر المحافظة:</label>
        <select id="governorate_id" name="governorate_id" required>
            <option value="">-- اختر --</option>
            <?php
            $govs = $conn->query("SELECT GovernorateID, GovernorateName FROM governorates ORDER BY GovernorateName");
            while ($g = $govs->fetch_assoc()) {
                $selected = (isset($_POST['governorate_id']) && $_POST['governorate_id'] == $g['GovernorateID']) ? 'selected' : '';
                echo "<option value='{$g['GovernorateID']}' $selected>" . htmlspecialchars($g['GovernorateName']) . "</option>";
            }
            ?>
        </select>

        <label for="directorate_id">اختر الإدارة:</label>
        <select id="directorate_id" name="directorate_id">
            <option value="">-- اختر الإدارة --</option>
            <?php
            // إذا تم اختيار محافظة مسبقًا، نُحمل الإدارات الخاصة بها (لتجنب فراغ الإدارات بعد إعادة تحميل الصفحة)
            if (isset($_POST['governorate_id']) && $_POST['governorate_id'] != '') {
                $gov_id = intval($_POST['governorate_id']);
                $stmtDir = $conn->prepare("SELECT DirectorateID, DirectorateName FROM directorates WHERE GovernorateID = ?");
                $stmtDir->bind_param("i", $gov_id);
                $stmtDir->execute();
                $resDir = $stmtDir->get_result();
                while ($d = $resDir->fetch_assoc()) {
                    $selectedDir = (isset($_POST['directorate_id']) && $_POST['directorate_id'] == $d['DirectorateID']) ? 'selected' : '';
                    echo "<option value='{$d['DirectorateID']}' $selectedDir>" . htmlspecialchars($d['DirectorateName']) . "</option>";
                }
            }
            ?>
        </select>

        <button class="btn" name="process" type="submit">تحديث وعرض المكتمل</button>
    </form>

    <?php
    if (isset($_POST['process']) && isset($_POST['governorate_id']) && $_POST['governorate_id'] !== '') {
        $gov_id = intval($_POST['governorate_id']);
        $dir_id = (isset($_POST['directorate_id']) && $_POST['directorate_id'] !== '') ? intval($_POST['directorate_id']) : null;

        // تحديث الحالة إلى مكتمل للمدارس التي تحقق شرط وجود جميع الأقسام
        // استخدم prepared statement للأمان
        if ($dir_id) {
            $update_sql = "UPDATE basicqualityforms bqf
                           JOIN schools s ON bqf.SchoolID = s.SchoolID
                           SET bqf.Status = 'مكتمل'
                           WHERE EXISTS (
                               SELECT 1 FROM teacherssection_1 t1
                               JOIN activitiessection_2 a2 ON t1.SchoolID = a2.SchoolID
                               JOIN facilitiessection_3 f3 ON t1.SchoolID = f3.SchoolID
                               JOIN childrenevaluation_4 c4 ON t1.SchoolID = c4.SchoolID
                               JOIN directassessment_5 d5 ON t1.SchoolID = d5.SchoolID
                               WHERE t1.SchoolID = bqf.SchoolID
                           ) AND s.DirectorateID = ?";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("i", $dir_id);
        } else {
            $update_sql = "UPDATE basicqualityforms bqf
                           JOIN schools s ON bqf.SchoolID = s.SchoolID
                           SET bqf.Status = 'مكتمل'
                           WHERE EXISTS (
                               SELECT 1 FROM teacherssection_1 t1
                               JOIN activitiessection_2 a2 ON t1.SchoolID = a2.SchoolID
                               JOIN facilitiessection_3 f3 ON t1.SchoolID = f3.SchoolID
                               JOIN childrenevaluation_4 c4 ON t1.SchoolID = c4.SchoolID
                               JOIN directassessment_5 d5 ON t1.SchoolID = d5.SchoolID
                               WHERE t1.SchoolID = bqf.SchoolID
                           ) AND s.DirectorateID IN (
                               SELECT DirectorateID FROM directorates WHERE GovernorateID = ?
                           )";
            $stmt_update = $conn->prepare($update_sql);
            $stmt_update->bind_param("i", $gov_id);
        }
        $stmt_update->execute();

        // استعلام عرض المدارس المكتملة حسب الاختيارات
        if ($dir_id) {
            $query = "SELECT bqf.userName, s.SchoolID, s.SchoolName, d.DirectorateName
                      FROM basicqualityforms bqf
                      JOIN schools s ON bqf.SchoolID = s.SchoolID
                      JOIN directorates d ON s.DirectorateID = d.DirectorateID
                      WHERE bqf.Status = 'مكتمل' AND d.DirectorateID = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $dir_id);
        } else {
            $query = "SELECT bqf.userName, s.SchoolID, s.SchoolName, d.DirectorateName
                      FROM basicqualityforms bqf
                      JOIN schools s ON bqf.SchoolID = s.SchoolID
                      JOIN directorates d ON s.DirectorateID = d.DirectorateID
                      WHERE bqf.Status = 'مكتمل' AND d.GovernorateID = ?";
            $stmt = $conn->prepare($query);
            $stmt->bind_param("i", $gov_id);
        }
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res && $res->num_rows > 0) {
            echo "<h3>قائمة المدارس المكتملة:</h3>";
            echo "<table>
                <tr>
                    <th>#</th>
                    <th>اسم المطبق</th>
                    <th>كود المدرسة</th>
                    <th>اسم المدرسة</th>
                    <th>الإدارة</th>
                </tr>";

            $counter = 1;
            while ($row = $res->fetch_assoc()) {
                echo "<tr>
                        <td>" . $counter++ . "</td>
                        <td>" . htmlspecialchars($row['userName']) . "</td>
                        <td>" . htmlspecialchars($row['SchoolID']) . "</td>
                        <td>" . htmlspecialchars($row['SchoolName']) . "</td>
                        <td>" . htmlspecialchars($row['DirectorateName']) . "</td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<div class='message'>لا توجد مدارس مكتملة في الاختيار الحالي.</div>";
        }

        // إحصائيات عدد المدارس المكتملة في الإدارات داخل المحافظة المختارة
        echo "<h3>إحصائيات الإدارات:</h3>";

        $stats_sql = "SELECT d.DirectorateName, COUNT(*) AS CompletedSchools
                      FROM basicqualityforms bqf
                      JOIN schools s ON bqf.SchoolID = s.SchoolID
                      JOIN directorates d ON s.DirectorateID = d.DirectorateID
                      WHERE bqf.Status = 'مكتمل' AND d.GovernorateID = ?
                      GROUP BY d.DirectorateID
                      ORDER BY d.DirectorateName ASC";
        $stmt_stats = $conn->prepare($stats_sql);
        $stmt_stats->bind_param("i", $gov_id);
        $stmt_stats->execute();
        $stats = $stmt_stats->get_result();

        if ($stats && $stats->num_rows > 0) {
            echo "<table>
                    <tr>
                        <th>الإدارة</th>
                        <th>عدد المدارس المكتملة</th>
                    </tr>";
            while ($row = $stats->fetch_assoc()) {
                echo "<tr>
                        <td>" . htmlspecialchars($row['DirectorateName']) . "</td>
                        <td>" . htmlspecialchars($row['CompletedSchools']) . "</td>
                      </tr>";
            }
            echo "</table>";
        } else {
            echo "<div class='message'>لا توجد إحصائيات متاحة للإدارات.</div>";
        }
    }
    ?>
</div>

<script>
$(document).ready(function() {
    // تحميل الإدارات عند اختيار المحافظة
    $('#governorate_id').change(function() {
        var gov_id = $(this).val();
        if (gov_id !== '') {
            $.ajax({
                url: 'complete_schools.php',
                type: 'GET',
                dataType: 'json',
                data: { get_directorates: 1, gov_id: gov_id },
                success: function(data) {
                    $('#directorate_id').empty().append('<option value="">-- اختر الإدارة --</option>');
                    $.each(data, function(i, item) {
                        $('#directorate_id').append('<option value="' + item.DirectorateID + '">' + item.DirectorateName + '</option>');
                    });
                },
                error: function(xhr, status, error) {
                    alert('فشل في تحميل الإدارات');
                    console.log(error);
                }
            });
        } else {
            $('#directorate_id').html('<option value="">-- اختر الإدارة --</option>');
        }
    });

    // عند إعادة تحميل الصفحة، إذا كانت هناك إدارات محددة سابقًا، لا نعيد تحميلها بالـ AJAX بل نعرضها مباشرة
});
</script>

</body>
</html>
