<?php
session_start();
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تقييم الأطفال من قبل القائم بالتطبيق - نظام متابعة الجودة</title>
    
    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-rtl@5.3.0/dist/css/bootstrap-rtl.min.css" rel="stylesheet">
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    
    <style>
        :root {
            --primary-color: #2c7873;
            --secondary-color: #6fb98f;
            --accent-color: #f8b400;
            --light-color: #f5f5f5;
            --dark-color: #2d4059;
            --success-color: #4caf50;
            --info-color: #00bcd4;
            --warning-color: #ff9800;
            --danger-color: #f44336;
        }
        
        body {
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            color: #333;
            line-height: 1.6;
        }
        
        .header {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: white;
            padding: 2rem 0;
            margin-bottom: 2rem;
            border-radius: 0 0 10px 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header h1 {
            font-weight: 700;
            margin-bottom: 0.5rem;
        }
        
        .header h2 {
            font-weight: 500;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 0;
        }
        
        .container {
            max-width: 1200px;
        }
        
        .nav-tabs {
            border-bottom: 2px solid #dee2e6;
            margin-bottom: 1.5rem;
        }
        
        .nav-tabs .nav-link {
            border: 1px solid #dee2e6;
            border-bottom: none;
            border-radius: 5px 5px 0 0;
            margin-left: 5px;
            background: #f8f9fa;
            color: var(--dark-color);
            font-weight: 500;
            padding: 12px 20px;
            transition: all 0.3s ease;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .nav-tabs .nav-link.active {
            background: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }
        
        .tab-content {
            padding: 25px;
            border: 1px solid #dee2e6;
            border-top: none;
            background: white;
            border-radius: 0 0 5px 5px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }
        
        .section {
            margin-bottom: 30px;
            padding: 25px;
            background-color: white;
            border-radius: 8px;
            border-left: 5px solid var(--primary-color);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
        
        .section-title {
            color: var(--primary-color);
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 25px;
            background: white;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        th, td {
            border: 1px solid #e0e0e0;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 500;
        }
        
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tr:hover {
            background-color: #f1f1f1;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            font-weight: 500;
            color: var(--dark-color);
            margin-bottom: 8px;
            display: block;
        }
        
        .radio-group {
            display: flex;
            gap: 20px;
            margin: 15px 0;
            flex-wrap: wrap;
        }
        
        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
            font-weight: normal;
        }
        
        input[type="text"],
        input[type="number"],
        input[type="email"],
        input[type="password"],
        select,
        textarea {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="number"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        select:focus,
        textarea:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(44, 120, 115, 0.1);
        }
        
        .btn-success {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 12px 30px;
            font-size: 18px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-success:hover {
            background-color: #246b66;
            border-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        
        .btn-success:active {
            transform: translateY(0);
        }
        
        .welcome-message {
            background-color: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
            border-left: 4px solid var(--accent-color);
        }
        
        .welcome-message h3 {
            color: var(--dark-color);
            margin-bottom: 0;
            font-weight: 600;
        }
        
        .icon {
            margin-left: 8px;
            color: var(--primary-color);
        }
        
        .disabled-row {
            opacity: 0.6;
            pointer-events: none;
        }
        
        /* Responsive adjustments */
        @media (max-width: 992px) {
            .nav-tabs .nav-link {
                padding: 10px 15px;
                font-size: 14px;
            }
            
            .section {
                padding: 20px;
            }
            
            th, td {
                padding: 10px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 768px) {
            .header {
                padding: 1.5rem 0;
            }
            
            .header h1 {
                font-size: 1.8rem;
            }
            
            .header h2 {
                font-size: 1.3rem;
            }
            
            .nav-tabs {
                flex-wrap: nowrap;
                overflow-x: auto;
                white-space: nowrap;
                -webkit-overflow-scrolling: touch;
                padding-bottom: 5px;
            }
            
            .nav-tabs .nav-link {
                padding: 8px 12px;
                font-size: 13px;
            }
            
            .tab-content {
                padding: 15px;
            }
            
            .section {
                padding: 15px;
            }
            
            table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }
            
            .radio-group {
                gap: 10px;
            }
        }
        
        @media (max-width: 576px) {
            .header h1 {
                font-size: 1.5rem;
            }
            
            .header h2 {
                font-size: 1.1rem;
            }
            
            .btn-success {
                width: 100%;
                padding: 12px;
            }
            
            .radio-group {
                flex-direction: column;
                gap: 8px;
            }
        }
        .btn {
    padding: 10px 20px;
    border-radius: 5px;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.3s;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
}

.btn-primary {
    background-color: var(--primary-color);
    color: white;
    border: 1px solid var(--primary-color);
}

.btn-primary:hover {
    background-color: #246b66;
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    color: white;
}

.btn-secondary {
    background-color: var(--light-color);
    color: var(--dark-color);
    border: 1px solid var(--primary-color);
}

.btn-secondary:hover {
    background-color: #e9ecef;
}

.btn-success {
    background-color: var(--success-color);
    color: white;
    border: 1px solid var(--success-color);
}

.btn-outline-secondary {
    background-color: transparent;
    color: var(--dark-color);
    border: 1px solid var(--secondary-color);
}

.btn-outline-secondary:hover {
    background-color: #f8f9fa;
}

.btn-link {
    background: none;
    border: none;
    color: var(--primary-color);
    padding: 0;
}

.btn-lg {
    padding: 12px 30px;
    font-size: 1.1rem;
}
    </style>
</head>

<body>
    <div class="header text-center">
        <div class="container">
            <h1><i class="fas fa-child icon"></i> استمارة متابعة نظام ضمان الجودة برياض الأطفال</h1>
            <h2><i class="fas fa-map-marker-alt icon"></i> في جمهورية مصر العربية</h2>
            <p><i class="fas fa-university icon"></i> المركز القومي للامتحانات والتقويم التربوي - القاهرة - مايو 2025</p>
        </div>
    </div>

         <ul class="nav nav-tabs" id="formTabs">
            <li class="nav-item">
                <a class="nav-link" href="general.php">
                    <i class="fas fa-info-circle"></i> البيانات العامة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="teachers.php"> 
                    <i class="fas fa-chalkboard-teacher"></i> مقابلة لمعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="activities.php">
                    <i class="fas fa-book-open"></i> أنشطة التعليم والتعلم
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="facilities.php"> <i class="fas fa-school"></i> مرافق الروضة
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link " href="evaluation.php">
                    <i class="fas fa-clipboard-check"></i> تقويم الأطفال من وجهة نظر المعلمات
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link active" href="evaluation_5.php">
                    <i class="fas fa-user-tie"></i> تقييم الأطفال من قبل القائم بالتطبيق
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="manual.php">
                     <i class="fas fa-book"></i> دليل المستخدم
                </a>
            </li>
        </ul>
                                   
              <!-- Evaluation 5 Tab -->
                <div class="tab-pane fade show active" id="evaluation5">
                    <div class="section">
                        <h2 class="section-title"><i class="fas fa-user-tie"></i> المحور الخامس : تقويم الأطفال من قبل القائم بالتطبيق</h2>
                       
                       
                        <form action="save_evaluation_5.php" method="post">
                        <h3 class="section-title"><i class="fas fa-handshake"></i> أولاً: تحية وموافقة شفهية</h3>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>السؤال</th>
                                        <th colspan="2">الطفل الأول</th>
                                        <th colspan="2">الطفل الثاني</th>
                                        <th colspan="2">الطفل الثالث</th>
                                        <th colspan="2">الطفل الرابع</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                        <td>نعم</td>
                                        <td>لا</td>
                                    </tr>
                                    <tr>
                                        <td>هل كل شيء واضح؟</td>
                                        <td><input type="radio" name="child1_clear" value=2 required></td>
                                        <td><input type="radio" name="child1_clear" value=1></td>
                                        <td><input type="radio" name="child2_clear" value=2 ></td>
                                        <td><input type="radio" name="child2_clear" value=1></td>
                                        <td><input type="radio" name="child3_clear" value=2 ></td>
                                        <td><input type="radio" name="child3_clear" value=1></td>
                                        <td><input type="radio" name="child4_clear" value=2 ></td>
                                        <td><input type="radio" name="child4_clear" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>هل عندك أي أسئلة؟</td>
                                        <td><input type="radio" name="child1_haveQ" value=2 required></td>
                                        <td><input type="radio" name="child1_haveQ" value=1></td>
                                        <td><input type="radio" name="child2_haveQ" value=2 ></td>
                                        <td><input type="radio" name="child2_haveQ" value=1></td>
                                        <td><input type="radio" name="child3_haveQ" value=2 ></td>
                                        <td><input type="radio" name="child3_haveQ" value=1></td>
                                        <td><input type="radio" name="child4_haveQ" value=2 ></td>
                                        <td><input type="radio" name="child4_haveQ" value=1></td>
                                    </tr>
                                    <tr>
                                        <td>هل أنتِ مستعد لتبدأ؟</td>
                                        <td><input type="radio" name="child1_readytostart" value=2 required></td>
                                        <td><input type="radio" name="child1_readytostart" value=1></td>
                                        <td><input type="radio" name="child2_readytostart" value=2 ></td>
                                        <td><input type="radio" name="child2_readytostart" value=1></td>
                                        <td><input type="radio" name="child3_readytostart" value=2 ></td>
                                        <td><input type="radio" name="child3_readytostart" value=1></td>
                                        <td><input type="radio" name="child4_readytostart" value=2 ></td>
                                        <td><input type="radio" name="child4_readytostart" value=1></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
           
                        <h3 class="section-title"><i class="fas fa-clipboard-check"></i> ثانياً: التقييم الأساسي المباشر</h3>
                        
                        <h4><i class="fas fa-language"></i> 30- التعرف على صوت حروف (اللغة العربية)</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الحرف</th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>30-1</td>
                                        <td>حرف (م)</td>
                                        <td><input type="radio" name="Q30_1ch1" value=1 required></td>
                                        <td><input type="radio" name="Q30_1ch1" value=2></td>
                                        <td><input type="radio" name="Q30_1ch1" value=3></td>
                                        <td><input type="radio" name="Q30_1ch2" value=1 ></td>
                                        <td><input type="radio" name="Q30_1ch2" value=2></td>
                                        <td><input type="radio" name="Q30_1ch2" value=3></td>
                                        <td><input type="radio" name="Q30_1ch3" value=1 ></td>
                                        <td><input type="radio" name="Q30_1ch3" value=2></td>
                                        <td><input type="radio" name="Q30_1ch3" value=3></td>
                                        <td><input type="radio" name="Q30_1ch4" value=1 ></td>
                                        <td><input type="radio" name="Q30_1ch4" value=2></td>
                                        <td><input type="radio" name="Q30_1ch4" value=3></td>
                                    </tr>
                                    <!-- More rows would go here -->
                                     <tr>
                       <td>30-2</td>
                       <td>حرف (أ)</td>
                       <td><input type="radio" name="Q30_2ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_2ch1" value=2></td>
                       <td><input type="radio" name="Q30_2ch1" value=3></td>
                       <td><input type="radio" name="Q30_2ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_2ch2" value=2></td>
                       <td><input type="radio" name="Q30_2ch2" value=3></td>
                       <td><input type="radio" name="Q30_2ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_2ch3" value=2></td>
                       <td><input type="radio" name="Q30_2ch3" value=3></td>
                       <td><input type="radio" name="Q30_2ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_2ch4" value=2></td>
                       <td><input type="radio" name="Q30_2ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-3</td>
                       <td>حرف (ب)</td>
                       <td><input type="radio" name="Q30_3ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_3ch1" value=2></td>
                       <td><input type="radio" name="Q30_3ch1" value=3></td>
                       <td><input type="radio" name="Q30_3ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_3ch2" value=2></td>
                       <td><input type="radio" name="Q30_3ch2" value=3></td>
                       <td><input type="radio" name="Q30_3ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_3ch3" value=2></td>
                       <td><input type="radio" name="Q30_3ch3" value=3></td>
                       <td><input type="radio" name="Q30_3ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_3ch4" value=2></td>
                       <td><input type="radio" name="Q30_3ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-4</td>
                       <td>حرف (ع)</td>
                       <td><input type="radio" name="Q30_4ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_4ch1" value=2></td>
                       <td><input type="radio" name="Q30_4ch1" value=3></td>
                       <td><input type="radio" name="Q30_4ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_4ch2" value=2></td>
                       <td><input type="radio" name="Q30_4ch2" value=3></td>
                       <td><input type="radio" name="Q30_4ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_4ch3" value=2></td>
                       <td><input type="radio" name="Q30_4ch3" value=3></td>
                       <td><input type="radio" name="Q30_4ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_4ch4" value=2></td>
                       <td><input type="radio" name="Q30_4ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-5</td>
                       <td>حرف (ت)</td>
                       <td><input type="radio" name="Q30_5ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_5ch1" value=2></td>
                       <td><input type="radio" name="Q30_5ch1" value=3></td>
                       <td><input type="radio" name="Q30_5ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_5ch2" value=2></td>
                       <td><input type="radio" name="Q30_5ch2" value=3></td>
                       <td><input type="radio" name="Q30_5ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_5ch3" value=2></td>
                       <td><input type="radio" name="Q30_5ch3" value=3></td>
                       <td><input type="radio" name="Q30_5ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_5ch4" value=2></td>
                       <td><input type="radio" name="Q30_5ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-6</td>
                       <td>حرف (ج)</td>
                       <td><input type="radio" name="Q30_6ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_6ch1" value=2></td>
                       <td><input type="radio" name="Q30_6ch1" value=3></td>
                       <td><input type="radio" name="Q30_6ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_6ch2" value=2></td>
                       <td><input type="radio" name="Q30_6ch2" value=3></td>
                       <td><input type="radio" name="Q30_6ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_6ch3" value=2></td>
                       <td><input type="radio" name="Q30_6ch3" value=3></td>
                       <td><input type="radio" name="Q30_6ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_6ch4" value=2></td>
                       <td><input type="radio" name="Q30_6ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-7</td>
                       <td>حرف (ن)</td>
                       <td><input type="radio" name="Q30_7ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_7ch1" value=2></td>
                       <td><input type="radio" name="Q30_7ch1" value=3></td>
                       <td><input type="radio" name="Q30_7ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_7ch2" value=2></td>
                       <td><input type="radio" name="Q30_7ch2" value=3></td>
                       <td><input type="radio" name="Q30_7ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_7ch3" value=2></td>
                       <td><input type="radio" name="Q30_7ch3" value=3></td>
                       <td><input type="radio" name="Q30_7ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_7ch4" value=2></td>
                       <td><input type="radio" name="Q30_7ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>30-8</td>
                       <td>حرف (و)</td>
                       <td><input type="radio" name="Q30_8ch1" value=1 required></td>
                       <td><input type="radio" name="Q30_8ch1" value=2></td>
                       <td><input type="radio" name="Q30_8ch1" value=3></td>
                       <td><input type="radio" name="Q30_8ch2" value=1 ></td>
                       <td><input type="radio" name="Q30_8ch2" value=2></td>
                       <td><input type="radio" name="Q30_8ch2" value=3></td>
                       <td><input type="radio" name="Q30_8ch3" value=1 ></td>
                       <td><input type="radio" name="Q30_8ch3" value=2></td>
                       <td><input type="radio" name="Q30_8ch3" value=3></td>
                       <td><input type="radio" name="Q30_8ch4" value=1 ></td>
                       <td><input type="radio" name="Q30_8ch4" value=2></td>
                       <td><input type="radio" name="Q30_8ch4" value=3></td>
                   </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- More evaluation tables would go here -->
                        <h4><i class="fas fa-language"></i> 31-التعرف على صوت حروف (اللغة الإنجليزية)</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>الحرف</th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>31-1</td>
                                        <td>(m) حرف</td>
                                        <td><input type="radio" name="Q31_1ch1" value=1 required></td>
                                        <td><input type="radio" name="Q31_1ch1" value=2></td>
                                        <td><input type="radio" name="Q31_1ch1" value=3></td>
                                        <td><input type="radio" name="Q31_1ch2" value=1 ></td>
                                        <td><input type="radio" name="Q31_1ch2" value=2></td>
                                        <td><input type="radio" name="Q31_1ch2" value=3></td>
                                        <td><input type="radio" name="Q31_1ch3" value=1 ></td>
                                        <td><input type="radio" name="Q31_1ch3" value=2></td>
                                        <td><input type="radio" name="Q31_1ch3" value=3></td>
                                        <td><input type="radio" name="Q31_1ch4" value=1 ></td>
                                        <td><input type="radio" name="Q31_1ch4" value=2></td>
                                        <td><input type="radio" name="Q31_1ch4" value=3></td>
                                    </tr>
                                  <tr>
                       <td>31-2</td>
                       <td>(a) حرف </td>
                       <td><input type="radio" name="Q31_2ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_2ch1" value=2></td>
                       <td><input type="radio" name="Q31_2ch1" value=3></td>
                       <td><input type="radio" name="Q31_2ch2" value=1 ></td>
                       <td><input type="radio" name="Q31_2ch2" value=2></td>
                       <td><input type="radio" name="Q31_2ch2" value=3></td>
                       <td><input type="radio" name="Q31_2ch3" value=1 ></td>
                       <td><input type="radio" name="Q31_2ch3" value=2></td>
                       <td><input type="radio" name="Q31_2ch3" value=3></td>
                       <td><input type="radio" name="Q31_2ch4" value=1 ></td>
                       <td><input type="radio" name="Q31_2ch4" value=2></td>
                       <td><input type="radio" name="Q31_2ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-3</td>
                       <td>(b) حرف </td>
                       <td><input type="radio" name="Q31_3ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_3ch1" value=2></td>
                       <td><input type="radio" name="Q31_3ch1" value=3></td>
                       <td><input type="radio" name="Q31_3ch2" value=1 ></td>
                       <td><input type="radio" name="Q31_3ch2" value=2></td>
                       <td><input type="radio" name="Q31_3ch2" value=3></td>
                       <td><input type="radio" name="Q31_3ch3" value=1 ></td>
                       <td><input type="radio" name="Q31_3ch3" value=2></td>
                       <td><input type="radio" name="Q31_3ch3" value=3></td>
                       <td><input type="radio" name="Q31_3ch4" value=1 ></td>
                       <td><input type="radio" name="Q31_3ch4" value=2></td>
                       <td><input type="radio" name="Q31_3ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-4</td>
                       <td>(y) حرف </td>
                       <td><input type="radio" name="Q31_4ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_4ch1" value=2></td>
                       <td><input type="radio" name="Q31_4ch1" value=3></td>
                       <td><input type="radio" name="Q31_4ch2" value=1 ></td>
                       <td><input type="radio" name="Q31_4ch2" value=2></td>
                       <td><input type="radio" name="Q31_4ch2" value=3></td>
                       <td><input type="radio" name="Q31_4ch3" value=1 ></td>
                       <td><input type="radio" name="Q31_4ch3" value=2></td>
                       <td><input type="radio" name="Q31_4ch3" value=3></td>
                       <td><input type="radio" name="Q31_4ch4" value=1 ></td>
                       <td><input type="radio" name="Q31_4ch4" value=2></td>
                       <td><input type="radio" name="Q31_4ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-5</td>
                       <td>(t) حرف </td>
                       <td><input type="radio" name="Q31_5ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_5ch1" value=2></td>
                       <td><input type="radio" name="Q31_5ch1" value=3></td>
                       <td><input type="radio" name="Q31_5ch2" value=1 ></td>
                       <td><input type="radio" name="Q31_5ch2" value=2></td>
                       <td><input type="radio" name="Q31_5ch2" value=3></td>
                       <td><input type="radio" name="Q31_5ch3" value=1 ></td>
                       <td><input type="radio" name="Q31_5ch3" value=2></td>
                       <td><input type="radio" name="Q31_5ch3" value=3></td>
                       <td><input type="radio" name="Q31_5ch4" value=1></td>
                       <td><input type="radio" name="Q31_5ch4" value=2></td>
                       <td><input type="radio" name="Q31_5ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-6</td>
                       <td>(j) حرف </td>
                       <td><input type="radio" name="Q31_6ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_6ch1" value=2></td>
                       <td><input type="radio" name="Q31_6ch1" value=3></td>
                       <td><input type="radio" name="Q31_6ch2" value=1></td>
                       <td><input type="radio" name="Q31_6ch2" value=2></td>
                       <td><input type="radio" name="Q31_6ch2" value=3></td>
                       <td><input type="radio" name="Q31_6ch3" value=1></td>
                       <td><input type="radio" name="Q31_6ch3" value=2></td>
                       <td><input type="radio" name="Q31_6ch3" value=3></td>
                       <td><input type="radio" name="Q31_6ch4" value=1></td>
                       <td><input type="radio" name="Q31_6ch4" value=2></td>
                       <td><input type="radio" name="Q31_6ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-7</td>
                       <td>(n) حرف </td>
                       <td><input type="radio" name="Q31_7ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_7ch1" value=2></td>
                       <td><input type="radio" name="Q31_7ch1" value=3></td>
                       <td><input type="radio" name="Q31_7ch2" value=1></td>
                       <td><input type="radio" name="Q31_7ch2" value=2></td>
                       <td><input type="radio" name="Q31_7ch2" value=3></td>
                       <td><input type="radio" name="Q31_7ch3" value=1></td>
                       <td><input type="radio" name="Q31_7ch3" value=2></td>
                       <td><input type="radio" name="Q31_7ch3" value=3></td>
                       <td><input type="radio" name="Q31_7ch4" value=1></td>
                       <td><input type="radio" name="Q31_7ch4" value=2></td>
                       <td><input type="radio" name="Q31_7ch4" value=3></td>
                   </tr>
                   <tr>
                       <td>31-8</td>
                       <td>(w) حرف </td>
                       <td><input type="radio" name="Q31_8ch1" value=1 required></td>
                       <td><input type="radio" name="Q31_8ch1" value=2></td>
                       <td><input type="radio" name="Q31_8ch1" value=3></td>
                       <td><input type="radio" name="Q31_8ch2" value=1></td>
                       <td><input type="radio" name="Q31_8ch2" value=2></td>
                       <td><input type="radio" name="Q31_8ch2" value=3></td>
                       <td><input type="radio" name="Q31_8ch3" value=1></td>
                       <td><input type="radio" name="Q31_8ch3" value=2></td>
                       <td><input type="radio" name="Q31_8ch3" value=3></td>
                       <td><input type="radio" name="Q31_8ch4" value=1></td>
                       <td><input type="radio" name="Q31_8ch4" value=2></td>
                       <td><input type="radio" name="Q31_8ch4" value=3></td>
                   </tr>
   
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-pen"></i> 32- كتابة الأسماء</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                        <td> صحيحة</td>
                                        <td> غير صحيحة </td>
                                        <td>لا أعرف</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>يطلب من الطفل كتابة اسمه</td>
                                        <td><input type="radio" name="Q32ch1" value=1 required></td>
                                        <td><input type="radio" name="Q32ch1" value=2></td>
                                        <td><input type="radio" name="Q32ch1" value=3></td>
                                        <td><input type="radio" name="Q32ch2" value=1></td>
                                        <td><input type="radio" name="Q32ch2" value=2></td>
                                        <td><input type="radio" name="Q32ch2" value=3></td>
                                        <td><input type="radio" name="Q32ch3" value=1></td>
                                        <td><input type="radio" name="Q32ch3" value=2></td>
                                        <td><input type="radio" name="Q32ch3" value=3></td>
                                        <td><input type="radio" name="Q32ch4" value=1></td>
                                        <td><input type="radio" name="Q32ch4" value=2></td>
                                        <td><input type="radio" name="Q32ch4" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-sort-numeric-up"></i> 33- العد اللفظي</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                        <td> كامل</td>
                                        <td> جزئى صحيح</td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td></td>
                                        <td>يطلب من الطفل العد اللفظي للأرقام</td>
                                        <td><input type="radio" name="Q33ch1" value=1 required></td>
                                        <td><input type="radio" name="Q33ch1" value=2></td>
                                        <td><input type="radio" name="Q33ch1" value=3></td>
                                        <td><input type="radio" name="Q33ch2" value=1></td>
                                        <td><input type="radio" name="Q33ch2" value=2></td>
                                        <td><input type="radio" name="Q33ch2" value=3></td>
                                        <td><input type="radio" name="Q33ch3" value=1></td>
                                        <td><input type="radio" name="Q33ch3" value=2></td>
                                        <td><input type="radio" name="Q33ch3" value=3></td>
                                        <td><input type="radio" name="Q33ch4" value=1></td>
                                        <td><input type="radio" name="Q33ch4" value=2></td>
                                        <td><input type="radio" name="Q33ch4" value=3></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-shapes"></i> 34- الأشكال الهندسية: تستخدم ورقة عمل (3) الأشكال الهندسية</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1-34</td>
                                        <td>التعرف على الدائرة</td>
                                        <td><input type="radio" name="Q34_1ch1" value=1 required></td>
                                        <td><input type="radio" name="Q34_1ch1" value=2></td>
                                        <td><input type="radio" name="Q34_1ch1" value=3></td>
                                        <td><input type="radio" name="Q34_1ch2" value=1></td>
                                        <td><input type="radio" name="Q34_1ch2" value=2></td>
                                        <td><input type="radio" name="Q34_1ch2" value=3></td>
                                        <td><input type="radio" name="Q34_1ch3" value=1 ></td>
                                        <td><input type="radio" name="Q34_1ch3" value=2></td>
                                        <td><input type="radio" name="Q34_1ch3" value=3></td>
                                        <td><input type="radio" name="Q34_1ch4" value=1></td>
                                        <td><input type="radio" name="Q34_1ch4" value=2></td>
                                        <td><input type="radio" name="Q34_1ch4" value=3></td>
                                    </tr>
                                     <tr>
                    <td>2-34</td>
                    <td>التعرف على المثلث</td>
                    <td><input type="radio" name="Q34_2ch1" value=1 required></td>
                    <td><input type="radio" name="Q34_2ch1" value=2></td>
                    <td><input type="radio" name="Q34_2ch1" value=3></td>
                    <td><input type="radio" name="Q34_2ch2" value=1></td>
                    <td><input type="radio" name="Q34_2ch2" value=2></td>
                    <td><input type="radio" name="Q34_2ch2" value=3></td>
                    <td><input type="radio" name="Q34_2ch3" value=1></td>
                    <td><input type="radio" name="Q34_2ch3" value=2></td>
                    <td><input type="radio" name="Q34_2ch3" value=3></td>
                    <td><input type="radio" name="Q34_2ch4" value=1></td>
                    <td><input type="radio" name="Q34_2ch4" value=2></td>
                    <td><input type="radio" name="Q34_2ch4" value=3></td>
                </tr>
                <tr>
                    <td>3-34</td>
                    <td>التعرف على المستطيل</td>
                    <td><input type="radio" name="Q34_3ch1" value=1 required></td>
                    <td><input type="radio" name="Q34_3ch1" value=2></td>
                    <td><input type="radio" name="Q34_3ch1" value=3></td>
                    <td><input type="radio" name="Q34_3ch2" value=1></td>
                    <td><input type="radio" name="Q34_3ch2" value=2></td>
                    <td><input type="radio" name="Q34_3ch2" value=3></td>
                    <td><input type="radio" name="Q34_3ch3" value=1></td>
                    <td><input type="radio" name="Q34_3ch3" value=2></td>
                    <td><input type="radio" name="Q34_3ch3" value=3></td>
                    <td><input type="radio" name="Q34_3ch4" value=1></td>
                    <td><input type="radio" name="Q34_3ch4" value=2></td>
                    <td><input type="radio" name="Q34_3ch4" value=3></td>
                </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <h4><i class="fas fa-book"></i> 35- المنهج متعدد التخصصات: تستخدم ورقة عمل (4) الأعلام، وتستخدم ورقة عمل (5) الطقس.</h4>
                        
                        <div class="table-responsive">
                            <table class="table-bordered">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th colspan="3">الطفل الأول</th>
                                        <th colspan="3">الطفل الثاني</th>
                                        <th colspan="3">الطفل الثالث</th>
                                        <th colspan="3">الطفل الرابع</th>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                        <td> مناسبة</td>
                                        <td> غير مناسبة </td>
                                        <td>لم يستجيب</td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1-35</td>
                                        <td>ما اسم روضتك؟</td>
                                        <td><input type="radio" name="Q35_1ch1" value=1 required></td>
                                        <td><input type="radio" name="Q35_1ch1" value=2></td>
                                        <td><input type="radio" name="Q35_1ch1" value=3></td>
                                        <td><input type="radio" name="Q35_1ch2" value=1></td>
                                        <td><input type="radio" name="Q35_1ch2" value=2></td>
                                        <td><input type="radio" name="Q35_1ch2" value=3></td>
                                        <td><input type="radio" name="Q35_1ch3" value=1></td>
                                        <td><input type="radio" name="Q35_1ch3" value=2></td>
                                        <td><input type="radio" name="Q35_1ch3" value=3></td>
                                        <td><input type="radio" name="Q35_1ch4" value=1></td>
                                        <td><input type="radio" name="Q35_1ch4" value=2></td>
                                        <td><input type="radio" name="Q35_1ch4" value=3></td>
                                    </tr>
                                    <tr>
                    <td>2-35</td>
                    <td>ممكن تقول اسم بلدنا</td>
                    <td><input type="radio" name="Q35_2ch1" value=1 required></td>
                    <td><input type="radio" name="Q35_2ch1" value=2></td>
                    <td><input type="radio" name="Q35_2ch1" value=3></td>
                    <td><input type="radio" name="Q35_2ch2" value=1></td>
                    <td><input type="radio" name="Q35_2ch2" value=2></td>
                    <td><input type="radio" name="Q35_2ch2" value=3></td>
                    <td><input type="radio" name="Q35_2ch3" value=1></td>
                    <td><input type="radio" name="Q35_2ch3" value=2></td>
                    <td><input type="radio" name="Q35_2ch3" value=3></td>
                    <td><input type="radio" name="Q35_2ch4" value=1></td>
                    <td><input type="radio" name="Q35_2ch4" value=2></td>
                    <td><input type="radio" name="Q35_2ch4" value=3></td>
                </tr>
                <tr>
                    <td>3-35</td>
                    <td>من اين تشترى الخضراوات</td>
                    <td><input type="radio" name="Q35_3ch1" value=1 required></td>
                    <td><input type="radio" name="Q35_3ch1" value=2></td>
                    <td><input type="radio" name="Q35_3ch1" value=3></td>
                    <td><input type="radio" name="Q35_3ch2" value=1></td>
                    <td><input type="radio" name="Q35_3ch2" value=2></td>
                    <td><input type="radio" name="Q35_3ch2" value=3></td>
                    <td><input type="radio" name="Q35_3ch3" value=1></td>
                    <td><input type="radio" name="Q35_3ch3" value=2></td>
                    <td><input type="radio" name="Q35_3ch3" value=3></td>
                    <td><input type="radio" name="Q35_3ch4" value=1></td>
                    <td><input type="radio" name="Q35_3ch4" value=2></td>
                    <td><input type="radio" name="Q35_3ch4" value=3></td>
                </tr>
                <tr>
                    <td>4-35</td>
                    <td>هل يمكنك أن تشير إلى علم مصر؟</td>
                    <td><input type="radio" name="Q35_4ch1" value=1 required></td>
                    <td><input type="radio" name="Q35_4ch1" value=2></td>
                    <td><input type="radio" name="Q35_4ch1" value=3></td>
                    <td><input type="radio" name="Q35_4ch2" value=1></td>
                    <td><input type="radio" name="Q35_4ch2" value=2></td>
                    <td><input type="radio" name="Q35_4ch2" value=3></td>
                    <td><input type="radio" name="Q35_4ch3" value=1></td>
                    <td><input type="radio" name="Q35_4ch3" value=2></td>
                    <td><input type="radio" name="Q35_4ch3" value=3></td>
                    <td><input type="radio" name="Q35_4ch4" value=1></td>
                    <td><input type="radio" name="Q35_4ch4" value=2></td>
                    <td><input type="radio" name="Q35_4ch4" value=3></td>
                </tr>
                <tr>
                    <td>5-35</td>
                    <td>ما مصدر الدفء في الصور؟</td>
                    <td><input type="radio" name="Q35_5ch1" value=1 required></td>
                    <td><input type="radio" name="Q35_5ch1" value=2></td>
                    <td><input type="radio" name="Q35_5ch1" value=3></td>
                    <td><input type="radio" name="Q35_5ch2" value=1></td>
                    <td><input type="radio" name="Q35_5ch2" value=2></td>
                    <td><input type="radio" name="Q35_5ch2" value=3></td>
                    <td><input type="radio" name="Q35_5ch3" value=1></td>
                    <td><input type="radio" name="Q35_5ch3" value=2></td>
                    <td><input type="radio" name="Q35_5ch3" value=3></td>
                    <td><input type="radio" name="Q35_5ch4" value=1></td>
                    <td><input type="radio" name="Q35_5ch4" value=2></td>
                    <td><input type="radio" name="Q35_5ch4" value=3></td>
                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
           
                <button type="submit" class="btn btn-success">حفظ بيانات تقييم الأطفال من قبل القائم بالتطبيق</button>
            </form>
        </div>
    </div>
<script>
     // General form validity check
                    if (!this.checkValidity()) {
                        e.preventDefault();
                        e.stopPropagation();
                        this.classList.add('was-validated'); // Bootstrap validation styles
                        alert('يرجى ملء جميع الحقول المطلوبة بشكل صحيح.');
                    } else {
                        const saveButton = this.querySelector('.btn-custom-save');
                        if (saveButton) {
                            const originalText = saveButton.innerHTML;
                            saveButton.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جاري الحفظ...';
                            saveButton.disabled = true;
                            // Form will submit normally.
                        }
                    }
</script>
</body>

</html>





