<?php
session_start();
include 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Validate required session variables
    if (!isset($_SESSION['current_form_id']) || !isset($_SESSION['school_id'])) {
        $_SESSION['error'] = "يجب البدء من صفحة البيانات العامة أولاً";
        header("Location: general.php");
        exit;
    }

    // Get values from form with proper validation
    $writing_tools = isset($_POST['AQ8']) ? (int)$_POST['AQ8'] : null;
    $objects_for_play = isset($_POST['AQ9']) ? (int)$_POST['AQ9'] : null;
    $tools_for_class_management = isset($_POST['AQ10']) ? (int)$_POST['AQ10'] : null;
    
    // Teacher 1 fields
    $feedback_teacher1 = isset($_POST['t1r11']) ? (int)$_POST['t1r11'] : null;
    $discussion_teacher1 = isset($_POST['t1d12']) ? (int)$_POST['t1d12'] : null;
    $open_questions_teacher1 = isset($_POST['t1o13']) ? (int)$_POST['t1o13'] : null;
    $strategies1 = isset($_POST['t1o14']) ? (int)$_POST['t1o14'] : null;
    $link_skills1 = isset($_POST['t1o15']) ? (int)$_POST['t1o15'] : null;
    $positive_behavior1 = isset($_POST['t1o16']) ? (int)$_POST['t1o16'] : null;
    $behavior_management1 = isset($_POST['t1o17']) ? (int)$_POST['t1o17'] : null;
    
    // Teacher 2 fields
    $feedback_teacher2 = isset($_POST['t2r11']) ? (int)$_POST['t2r11'] : null;
    $discussion_teacher2 = isset($_POST['t2d12']) ? (int)$_POST['t2d12'] : null;
    $open_questions_teacher2 = isset($_POST['t2o13']) ? (int)$_POST['t2o13'] : null;
    $strategies2 = isset($_POST['t2o14']) ? (int)$_POST['t2o14'] : null;
    $link_skills2 = isset($_POST['t2o15']) ? (int)$_POST['t2o15'] : null;
    $positive_behavior2 = isset($_POST['t2o16']) ? (int)$_POST['t2o16'] : null;
    $behavior_management2 = isset($_POST['t2o17']) ? (int)$_POST['t2o17'] : null;

    $SchoolID = $_SESSION['school_id'];
    
    $FormID = $_SESSION['current_form_id'];

    try {
        $sql = "INSERT INTO activitiessection_2 (
            SchoolID,
            tech1WritingTools8,
            tech1ManipulativeObjects9,
            tech1ClassroomManagementTools10,
            Teacher1Feedback11,
            Teacher1Discussion12,
            tech1OpenEndedQuestions13,
            Tech1TeachingStrategies14,
            Tech1LifeSkillsConnection15,
            tech1PositiveInteraction16,
            tech1BehaviorManagement17,
            Teacher2Feedback11,
            Teacher2Discussion12,
            tech2OpenEndedQuestions13,
            Tech2TeachingStrategies14,
            Tech2LifeSkillsConnection15,
            tech2PositiveInteraction16,
            tech2BehaviorManagement17
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
    tech1WritingTools8 = VALUES(tech1WritingTools8),
    tech1ManipulativeObjects9 = VALUES(tech1ManipulativeObjects9),
    tech1ClassroomManagementTools10 = VALUES(tech1ClassroomManagementTools10),
    Teacher1Feedback11 = VALUES(Teacher1Feedback11),
    Teacher1Discussion12 = VALUES(Teacher1Discussion12),
    tech1OpenEndedQuestions13 = VALUES(tech1OpenEndedQuestions13),
    Tech1TeachingStrategies14 = VALUES(Tech1TeachingStrategies14),
    Tech1LifeSkillsConnection15 = VALUES(Tech1LifeSkillsConnection15),
    tech1PositiveInteraction16 = VALUES(tech1PositiveInteraction16),
    tech1BehaviorManagement17 = VALUES(tech1BehaviorManagement17),
    Teacher2Feedback11 = VALUES(Teacher2Feedback11),
    Teacher2Discussion12 = VALUES(Teacher2Discussion12),
    tech2OpenEndedQuestions13 = VALUES(tech2OpenEndedQuestions13),
    Tech2TeachingStrategies14 = VALUES(Tech2TeachingStrategies14),
    Tech2LifeSkillsConnection15 = VALUES(Tech2LifeSkillsConnection15),
    tech2PositiveInteraction16 = VALUES(tech2PositiveInteraction16),
    tech2BehaviorManagement17 = VALUES(tech2BehaviorManagement17)";

        $stmt = $conn->prepare($sql);
        if (!$stmt) {
            throw new Exception("فشل إعداد الاستعلام: " . $conn->error);
        }

        $stmt->bind_param(
            "iiiiiiiiiiiiiiiiii",
            $SchoolID,
            $writing_tools,
            $objects_for_play,
            $tools_for_class_management,
            $feedback_teacher1,
            $discussion_teacher1,
            $open_questions_teacher1,
            $strategies1,
            $link_skills1,
            $positive_behavior1,
            $behavior_management1,
            $feedback_teacher2,
            $discussion_teacher2,
            $open_questions_teacher2,
            $strategies2,
            $link_skills2,
            $positive_behavior2,
            $behavior_management2
        );

        if ($stmt->execute()) {
            $_SESSION['success'] = "تم حفظ بيانات الأنشطة بنجاح";
            header("Location: facilities.php");
            exit;
        } else {
            throw new Exception("فشل في تنفيذ الاستعلام: " . $stmt->error);
        }
    } catch (Exception $e) {
        error_log("Error in save_activities.php: " . $e->getMessage());
        $_SESSION['error'] = "حدث خطأ أثناء حفظ البيانات: " . $e->getMessage();
        header("Location: activities.php");
        exit;
    }
} else {
    $_SESSION['error'] = "الطلب غير صالح";
    header("Location: activities.php");
    exit;
}