<?php
include 'config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Clear any temporary session data if needed
unset($_SESSION['form_data']);
?>
<!DOCTYPE html>
<html dir="rtl" lang="ar">
<head>
    <meta charset="UTF-8">
    <title>تم الحفظ بنجاح</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body { 
            font-family: 'Tajawal', sans-serif;
            background-color: #f9f9f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .success-container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 600px;
            width: 90%;
        }
        .success-icon {
            color: var(--success-color);
            font-size: 60px;
            margin-bottom: 20px;
        }
        h2 {
            color: var(--primary-color);
            margin-bottom: 15px;
        }
        p {
            color: var(--dark-color);
            margin-bottom: 30px;
            font-size: 18px;
        }
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }
        .btn {
            padding: 12px 25px;
            border-radius: 5px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s;
        }
        .btn-primary {
            background-color:  #246b66;
            color: white;
        }
        .btn-primary:hover {
            background-color: #246b66;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .btn-secondary {
            background-color: var(--light-color);
            color: var(--dark-color);
            border: 1px solid var(--primary-color);
        }
        .btn-secondary:hover {
            background-color: #e9ecef;
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">
            <i class="fas fa-check-circle"></i>
        </div>
        <h2>تم حفظ البيانات بنجاح</h2>
        <p>شكراً لك، تم إدخال جميع المحاور بنجاح في نظام متابعة جودة رياض الأطفال.</p>
        
        <div class="action-buttons">
            <a href="general.php" class="btn btn-primary">
                <i class="fas fa-plus"></i> إدخال بيانات روضة أخرى
            </a>
            <a href="logout.php" class="btn btn-secondary">
                <i class="fas fa-home"></i> خروج
            </a>
            
        </div>
    </div>
</body>
</html>